"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const dataTypes_1 = require("./dataTypes");
class ArrayCollection {
    constructor() {
        this.items = [];
    }
    add(...newItems) {
        this.items.push(...newItems);
    }
    get count() {
        return this.items.length;
    }
}
class ProductCollection extends ArrayCollection {
    get(searchTerm) {
        return this.items.find(item => item.name === name);
    }
}
class PersonCollection extends ArrayCollection {
    get(searchTerm) {
        return this.items.find(item => item.name === name || item.city === name);
    }
}
let peopleCollection = new PersonCollection();
peopleCollection.add(new dataTypes_1.Person("Bartek Nowak", "Londyn"), new dataTypes_1.Person("Dorota Petecka", "Nowy Jork"));
let productCollection = new ProductCollection();
productCollection.add(new dataTypes_1.Product("buty do biegania", 100), new dataTypes_1.Product("czapka", 25));
[peopleCollection, productCollection].forEach(c => console.log(`Wielkość: ${c.count}`));
